/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.planning.JobAccessibilityCallback;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.jobs.JobStore;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.messaging.types.JobAccessibilityRequestMessage;

@Singleton
public class JobAccessibilityUpdater
implements GameContextAware,
Updatable,
Telegraph,
JobAccessibilityCallback {
    public static final float DELAY_BEFORE_PATHING_RETRY_SECONDS = 10.0f;
    private final JobStore jobStore;
    private final MessageDispatcher messageDispatcher;
    private GameContext gameContext;
    private long lastUpdateTime = System.currentTimeMillis();

    @Inject
    public JobAccessibilityUpdater(JobStore jobStore, MessageDispatcher messageDispatcher) {
        this.jobStore = jobStore;
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addListener(this, 601);
    }

    @Override
    public void update(float deltaTime) {
        if (this.gameContext != null) {
            if (this.jobStore.getCollectionByState(JobState.PROCESSING_ACCESSIBILITY).size() > 0) {
                if (System.currentTimeMillis() - this.lastUpdateTime > 6000L) {
                    Job stillProcessingJob = this.jobStore.getCollectionByState(JobState.PROCESSING_ACCESSIBILITY).next();
                    this.jobStore.switchState(stillProcessingJob, JobState.INACCESSIBLE);
                    this.messageDispatcher.dispatchMessage(10.0f, 601, (Object)stillProcessingJob);
                }
                return;
            }
            this.lastUpdateTime = System.currentTimeMillis();
            Job job = this.jobStore.getCollectionByState(JobState.POTENTIALLY_ACCESSIBLE).next();
            if (job == null) {
                return;
            }
            Entity assignableEntity = this.getEntityToPathfindFrom(job);
            if (assignableEntity == null) {
                return;
            }
            Vector2 entityWorldPosition = assignableEntity.getLocationComponent().getWorldPosition();
            ArrayList<GridPoint2> jobLocations = new ArrayList<GridPoint2>();
            if (job.getType().isAccessedFromAdjacentTile()) {
                TileNeighbours jobNeighbourTiles = this.gameContext.getAreaMap().getOrthogonalNeighbours(job.getJobLocation().x, job.getJobLocation().y);
                for (CompassDirection compassDirection : jobNeighbourTiles.keySet()) {
                    if (((MapTile)jobNeighbourTiles.get((Object)compassDirection)).isNavigable()) continue;
                    jobNeighbourTiles.remove((Object)compassDirection);
                }
                if (jobNeighbourTiles.isEmpty()) {
                    this.jobStore.switchState(job, JobState.INACCESSIBLE);
                    return;
                }
                for (MapTile mapTile : jobNeighbourTiles.values()) {
                    jobLocations.add(mapTile.getTilePosition());
                }
                Collections.shuffle(jobLocations);
            } else {
                jobLocations.add(job.getJobLocation());
            }
            this.jobStore.switchState(job, JobState.PROCESSING_ACCESSIBILITY);
            this.messageDispatcher.dispatchMessage(401, new JobAccessibilityRequestMessage(job, entityWorldPosition, jobLocations, this, this.gameContext.getAreaMap()));
        }
    }

    @Override
    public boolean runWhilePaused() {
        return true;
    }

    private Entity getEntityToPathfindFrom(Job job) {
        Array<Entity> candidates = new Array<Entity>();
        for (Entity jobAssignableEntity : this.gameContext.getEntityStore().getJobAssignableEntities()) {
            ProfessionsComponent professionsComponent = jobAssignableEntity.getComponent(ProfessionsComponent.class);
            if (!professionsComponent.hasProfession(job.getRequiredProfession())) continue;
            candidates.add(jobAssignableEntity);
        }
        if (candidates.size == 0) {
            return null;
        }
        Entity nearestCandidate = null;
        float nearestDistance2 = Float.MAX_VALUE;
        Vector2 jobWorldPosition = new Vector2((float)job.getJobLocation().x + 0.5f, (float)job.getJobLocation().y + 0.5f);
        for (Entity candidate : candidates) {
            float distance2 = candidate.getLocationComponent().getWorldPosition().dst2(jobWorldPosition);
            if (!(distance2 < nearestDistance2)) continue;
            nearestDistance2 = distance2;
            nearestCandidate = candidate;
        }
        return nearestCandidate;
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 601: {
                Job job = (Job)msg.extraInfo;
                if (job == null) {
                    boolean bl = true;
                }
                if (job != null && JobState.INACCESSIBLE.equals((Object)job.getJobState())) {
                    for (Job jobAtLocation : this.jobStore.getJobsAtLocation(job.getJobLocation())) {
                        if (jobAtLocation.getJobId() != job.getJobId()) continue;
                        this.jobStore.switchState(job, JobState.POTENTIALLY_ACCESSIBLE);
                    }
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.jobStore.clear();
        this.gameContext = gameContext;
    }

    @Override
    public void onComplete(Job job, boolean isAccessible) {
        if (isAccessible) {
            this.jobStore.switchState(job, JobState.ASSIGNABLE);
        } else {
            this.jobStore.switchState(job, JobState.INACCESSIBLE);
            this.messageDispatcher.dispatchMessage(10.0f, 601, (Object)job);
        }
    }
}

